<?php

namespace App\Http\Controllers;

use App\Http\Requests\EntidadeRequest;
use App\Models\entidade;
use Illuminate\Http\Request;

use function PHPUnit\Framework\isInt;

class EntidadeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(){
        //$Entidade = Entidade::paginate(5); // buscando todos os dados da BD com paginação
        $user=  auth()->user();
        $Entidade = entidade::findOrFail($user->entidade_id);
        return view('entidade.index',compact('Entidade','user')); // = return view('Exemplo.blade',['Entidade'=> $Entidade]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(/*User $user*/)
    {
        
        //$users = $user->all(['id','name']);
        return view('entidade.create');        
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(String $nome,String $telefone){
        /*
        // $dados = $request->all();
        $Entidade = Entidade::create(
            [
                'nome'=>$nome,
                'telefone'=>$telefone,
            ]
        );
        return  $Entidade;
        */
    }

    /**
     * Display the specified resource.
     */
    public function show(String $id)
    {
        if (!is_numeric($id)) {
            abort(404, 'Entrada inválida.');
            exit();
        }
        $user = auth()->user();
        if($user->entidade_id==$id){
            $Entidade = entidade::findOrFail($id);
            return view('entidade.show',compact('Entidade','user'));
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
        
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(String $id)
    {
        if (!is_numeric($id)) {
            abort(404, 'Entrada inválida.');
            exit();
        }
        $user = auth()->user();
        if($user->entidade_id==$id and $user->role_id==1){
            $Entidade = entidade::findOrFail($id);
            return view('entidade.edit',compact('Entidade','user'));
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(EntidadeRequest $request,String $id){
        if(!isInt($id))
            $id=0;

        $user = auth()->user();
        if($user->entidade_id==$id and $user->role_id==1){
            $Entidade = Entidade::findORFail($id);
            $dados = $request->all();
            $Entidade->update(
                [
                    'nome'=>$dados['nome'],
                    'descricao'=>$dados['descricao'],
                    'sobre'=>$dados['sobre'],
                    'telefone'=>$dados['telefone'],
                    'email'=>$dados['email'],
                    'fundacao'=>$dados['fundacao'],
                ]
            );
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
        return redirect()->back();
        
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        $id = $request->valor;
        if(!isInt($id))
        { 
            $id=0;
        }

        $user = auth()->user();
        if($user->entidade_id==$id and $user->role_id==1){
            $Entidade = Entidade::findORFail($id);
            $Entidade->delete();
            return redirect()->back();
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }
}
